<?php

include_once "config.php";
date_default_timezone_set("Asia/Calcutta");

$output_csv = "SELECT * FROM oc_order WHERE sap_push = 0 AND order_status_id = 2";
$result = mysqli_query($connect, $output_csv);

if (mysqli_num_rows($result) > 0) {
    // FTP configuration
    $ftp_server = "ftp.example.com"; // Replace with your FTP server
    $ftp_username = "your-ftp-username"; // Replace with your FTP username
    $ftp_password = "your-ftp-password"; // Replace with your FTP password

    // Connect to FTP server
    $ftp_conn = ftp_connect($ftp_server) or die("Could not connect to $ftp_server");

    // Login to FTP
    if (@ftp_login($ftp_conn, $ftp_username, $ftp_password)) {
        echo "Connected to FTP server: $ftp_server\n";
    } else {
        die("FTP login failed\n");
    }

    // Loop through each order
    while ($row = mysqli_fetch_array($result)) {
        // File path for the CSV
        $file_path = './order/' . $row['order_id'] . '.csv';

        // Open file for writing
        $fp = fopen($file_path, 'w');
        if (!$fp) {
            echo "Error creating file: $file_path\n";
            continue;
        }

        // Write header to the CSV
        $output = array(
            's.no', 'Document Type', 'Sales Org', 'Distribution Channel', 'Division',
            'Reference', 'Reference Date', 'Sold to Party', 'Ship to Party', 'Delivery date',
            'Date for pricing', 'Item No', 'Material Number', 'Qty', 'UOM', 'Plant'
        );
        fputcsv($fp, $output);

        // Order details
        $Document_Type = "AN05";
        $Sales_Org = "9200";
        $Distribution_Channel = "NE";
        $Division = "E1";
        $Reference = $row['order_id'];
        $Reference_Date = date('Ymd', strtotime($row['date_added']));

        // Fetch Sold to Party and Ship to Party
        $zone_id = $row['shipping_zone_id'];
        $select_party = "SELECT * FROM oc_sap_code WHERE zone_id = $zone_id";
        $result_select_party = mysqli_query($connect, $select_party);
        $row_select_party = mysqli_fetch_array($result_select_party);
        $Sold_to_Party = $row_select_party['sap_id'];
        $Ship_to_Party = $row_select_party['sap_id'];

        // Other fields
        $Delivery_date = date('Ymd', strtotime($row['date_added']));
        $Date_for_pricing = $Delivery_date;
        $Plant = "9290";

        // Fetch order products
        $s_no = 1;
        $select_order_id = "SELECT * FROM oc_order_product WHERE order_id = $Reference";
        $result_order_id = mysqli_query($connect, $select_order_id);

        while ($row_product = mysqli_fetch_array($result_order_id)) {
            $Item_No = str_pad(10 * $s_no++, 6, '0', STR_PAD_LEFT);
            $Material_Number = $row_product['model'];
            $Qty = $row_product['quantity'];

            // Fetch UOM
            $Product_uom = $row_product['product_id'];
            $Select_UMO = "SELECT * FROM oc_product WHERE product_id = $Product_uom";
            $result_product_uom = mysqli_query($connect, $Select_UMO);
            $row_product_uom = mysqli_fetch_array($result_product_uom);
            $UOM = $row_product_uom['sku'];

            // Write product details to the CSV
            $test = array(
                trim($s_no - 1), trim($Document_Type), trim($Sales_Org), trim($Distribution_Channel),
                trim($Division), trim($Reference), trim($Reference_Date), trim($Sold_to_Party),
                trim($Ship_to_Party), trim($Delivery_date), trim($Date_for_pricing), $Item_No,
                trim($Material_Number), trim($Qty), trim($UOM), trim($Plant)
            );
            fputcsv($fp, $test, ",", " ");
        }

        // Close the CSV file
        fclose($fp);

        // Upload file to FTP server
        if (ftp_put($ftp_conn, 'order/' . $row['order_id'] . '.csv', $file_path, FTP_ASCII)) {
            echo "Successfully uploaded: " . $file_path . "\n";

            // Update order status to mark it as processed
            $update = "UPDATE oc_order SET sap_push = '1' WHERE order_id = $Reference";
            mysqli_query($connect, $update);
        } else {
            echo "Error uploading: " . $file_path . "\n";
        }
    }

    // Close the FTP connection
    ftp_close($ftp_conn);
} else {
    echo "No orders to process.\n";
}

?>
